/****************************************************************************
 *  @doc INTERNAL
 *  @module KE2700.h |
 *
 *  Keithley 2700 Multimeter/Data Acquisition System Header File
 *  <cp> Copyright 2000 Scientific Software Tools, Inc.<nl>
 *  All Rights Reserved.<nl>
 *  Portions Copyright <cp> 1991-2000 Microsoft Corporation
 *  Portions Copyright <cp>Q National Instruments 1998. All Rights Reserved.         
 *
 *  IVI instrument driver declarations
 *
 *  @comm   
 *  Author: RoyF<nl>
 *  Date:   7/26/2000 8:54:19 AM
 *
 *  @group Revision History
 *  @comm
 *  $Revision: 32 $
 *  <nl>
 *  $Log: /IVI/KE2700/KE2700.h $
 * 
 * 32    5/07/02 12:10p Xiuweng
 * 
 * 31    4/29/02 3:58p Xiuweng
 * 
 * 30    4/08/02 12:07p Xiuweng
 * support the model 2701
 * 
 * 29    3/26/02 11:51a Xiuweng
 * added new attributes and functions to support Model 2701 and NI
 * compliance test.
 * 
 * 28    12/04/01 10:30a Xiuweng
 * Added 2701 support
 * 
 * 27    10/18/01 4:42p Xiuweng
 * Added an attribute to lock/unlock front panel keys, fixed the RS-232
 * Timeout bug.
 * 
 * 26    5/24/01 12:37p Xiuweng
 * add dry circuit ohm error message
 * 
 * 25    5/23/01 11:57a Xiuweng
 * fixed the store task bug for ExceLINX
 * 
 * 24    4/05/01 11:09a Xiuweng
 * for final release.
 * 
 * 23    3/29/01 11:31a Xiuweng
 * fixed the known bugs
 * 
 * 22    3/27/01 2:35p Xiuweng
 * fixed some bugs
 * 
 * 21    3/15/01 12:19p Royf
 * Removed KE2700_ConvertTemperature function.
 * More function and attribute doc changes.
 * 
 * 20    3/15/01 11:03a Xiuweng
 * Remove three ROUT Attributes: MULTIPLE_CHANNELS_CLOSED,
 * ALL_CHANNEL_OPEN, CHANNELS_CURRENT_CLOSED;
 * add code to match the modification of FILTER_TYPE, FREQ_VOLTAGE_RANGE;
 * Fixed some bugs for totalizer, Analog Output, Digital IO.
 * 
 * 19    3/14/01 6:03p Royf
 * Attribute documentation edits.
 * 
 * 18    3/13/01 11:53a Xiuweng
 * add some new functions and attributes
 * 
 * 17    3/08/01 11:49a Xiuweng
 * 
 * 16    3/06/01 3:53p Xiuweng
 * fixed some bugs
 * 
 * 15    2/14/01 2:53p Xiuweng
 * 
 * 14    2/13/01 11:24a Xiuweng
 * fixed some bugs detected by unit tests
 * 
 * 13    2/08/01 1:43p Xiuweng
 * 
 * 12    1/25/01 12:08p Xiuweng
 * 
 * 11    1/23/01 1:50p Xiuweng
 * changed some function names, arguments and add the new attribute
 * KE2700_ATTR_NEXT_BUFFER_INDEX. improved some function features such as
 * FetchMultiReading  when start = -1, ConfigureMultiPoint allow
 * SampleTrigger be all of the different trigger source, etc.
 * 
 * 10    1/09/01 4:07p Xiuweng
 * add a function  GetChannelName() and delete two test functions
 * 
 * 9     1/09/01 2:18p Royf
 * Updated Driver Description attribute
 * 
 * 8     1/09/01 1:28p Xiuweng
 * add two attributes: Channel_Count, Channel_Names and modified some
 * function names.
 * 
 * 7     12/28/00 10:26a Xiuweng
 * add an attributes and  two additional ranges for model 2750 in dry
 * circuit Ohm measurement.
 * 
 * 6     12/21/00 2:54p Xiuweng
 * add the function 'SetupChannelScan'
 * 
 * 5     12/19/00 4:57p Xiuweng
 * Eleminate the ' _IS_' in b=ViBoolean Attribute names.
 * 
 * 4     12/18/00 3:47p Xiuweng
 * 
 * 3     12/18/00 1:24p Xiuweng
 * add the two attributes: DISPLAY_MESSAGE and IS_MESSAGE_ENABLED.
 * 
 * 2     12/12/00 3:54p Xiuweng
 * support the model 2750
 * 
 * 1     12/04/00 3:28p Xiuweng
 * change the Prefix "KI2700" of IVI driver  into "KE2700"
 * 
 * 12    11/17/00 1:59p Xiuweng
 * change the Argument 'format' of function 'BufferInfo ()' as pointer.
 * 
 * 11    11/16/00 3:42p Xiuweng
 * 
 * 10    10/20/00 2:25p Xiuweng
 * Add 'start' argument in DumpRawData( ).
 * 
 * 9     10/16/00 11:39a Xiuweng
 * 
 * 8     10/06/00 3:03p Xiuweng
 * 
 * 7     9/22/00 11:35a Xiuwen
 * 
 * 6     9/09/00 10:42a Xiuwen
 * 
 * 5     8/18/00 5:18p Xiuwen
 * initial version
 * 
 * 4     8/17/00 3:24p Xiuwen
 * check in for back up
 * 
 * 3     8/16/00 5:25p Xiuwen
 * CHECK IN FOR BACKUP
 * 
 * 2     8/11/00 4:19p Xiuwen
 * check in for backup
 * 
 * 1     7/26/00 8:56a Royf
 * Initial revision.
 *
 ****************************************************************************/

#ifndef __KE2700_HEADER
#define __KE2700_HEADER

#include "ivi.h"
#include "ividmm.h"

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/****************************************************************************
 *----------------- Instrument Driver Revision Information -----------------*
 ****************************************************************************/
#define KE2700_MAJOR_VERSION                2     /* Instrument driver major version   */
#define KE2700_MINOR_VERSION                0     /* Instrument driver minor version   */

#define KE2700_CLASS_SPEC_MAJOR_VERSION     2     /* Class specification major version */
#define KE2700_CLASS_SPEC_MINOR_VERSION     0     /* Class specification minor version */

#define KE2700_SUPPORTED_CLASSES            "IviDmm"
#define KE2700_SUPPORTED_INSTRUMENT_MODELS  "MODEL 2700,MODEL 2701,MODEL 2750"

#define KE2700_DRIVER_VENDOR                "Keithley Instruments, Inc."
#define KE2700_DRIVER_DESCRIPTION           "Keithley 2700/2750 Multimeter/Data Acquisition System"

#define KE2700_IO_SESSION_TYPE              "VISA"

/**************************************************************************** 
 *---------------------------- Attribute Defines ---------------------------* 
 ****************************************************************************/

/*- IVI Inherent Instrument Attributes ---------------------------------*/

        /* User Options */
#define KE2700_ATTR_RANGE_CHECK                   IVI_ATTR_RANGE_CHECK                    /* ViBoolean */
#define KE2700_ATTR_QUERY_INSTR_STATUS            IVI_ATTR_QUERY_INSTR_STATUS             /* ViBoolean */
#define KE2700_ATTR_CACHE                         IVI_ATTR_CACHE                          /* ViBoolean */
#define KE2700_ATTR_SIMULATE                      IVI_ATTR_SIMULATE                       /* ViBoolean */
#define KE2700_ATTR_RECORD_COERCIONS              IVI_ATTR_RECORD_COERCIONS               /* ViBoolean */

        /* Instrument Capabilities */
#define KE2700_ATTR_NUM_CHANNELS                  IVI_ATTR_NUM_CHANNELS                   /* ViInt32,  read-only  */
#define KE2700_ATTR_GROUP_CAPABILITIES            IVI_ATTR_GROUP_CAPABILITIES             /* ViString, read-only */

        /* Driver Information  */
#define KE2700_ATTR_SPECIFIC_DRIVER_PREFIX        IVI_ATTR_SPECIFIC_DRIVER_PREFIX         /* ViString, read-only  */
#define KE2700_ATTR_SUPPORTED_CLASSES             IVI_ATTR_SUPPORTED_CLASSES              /* ViString, read-only  */
#define KE2700_ATTR_SUPPORTED_INSTRUMENT_MODELS   IVI_ATTR_SUPPORTED_INSTRUMENT_MODELS    /* ViString, read-only  */
#define KE2700_ATTR_INSTRUMENT_MANUFACTURER       IVI_ATTR_INSTRUMENT_MANUFACTURER        /* ViString, read-only  */
#define KE2700_ATTR_INSTRUMENT_MODEL              IVI_ATTR_INSTRUMENT_MODEL               /* ViString, read-only  */
#define KE2700_ATTR_FIRMWARE_REVISION             IVI_ATTR_FIRMWARE_REVISION              /* ViString, read-only  */
#define KE2700_ATTR_SPECIFIC_DRIVER_MAJOR_VERSION IVI_ATTR_SPECIFIC_DRIVER_MAJOR_VERSION  /* ViInt32,  read-only  */
#define KE2700_ATTR_SPECIFIC_DRIVER_MINOR_VERSION IVI_ATTR_SPECIFIC_DRIVER_MINOR_VERSION  /* ViInt32,  read-only  */
#define KE2700_ATTR_SPECIFIC_DRIVER_REVISION      IVI_ATTR_SPECIFIC_DRIVER_REVISION       /* ViString, read-only  */
#define KE2700_ATTR_SPECIFIC_DRIVER_VENDOR        IVI_ATTR_SPECIFIC_DRIVER_VENDOR         /* ViString, read-only  */
#define KE2700_ATTR_SPECIFIC_DRIVER_DESCRIPTION   IVI_ATTR_SPECIFIC_DRIVER_DESCRIPTION    /* ViString, read-only  */
#define KE2700_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION IVI_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION /* ViInt32, read-only */
#define KE2700_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION IVI_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION /* ViInt32, read-only */

        /* Error Info */
#define KE2700_ATTR_PRIMARY_ERROR                 IVI_ATTR_PRIMARY_ERROR                  /* ViInt32   */
#define KE2700_ATTR_SECONDARY_ERROR               IVI_ATTR_SECONDARY_ERROR                /* ViInt32   */
#define KE2700_ATTR_ERROR_ELABORATION             IVI_ATTR_ERROR_ELABORATION              /* ViString  */

        /* Advanced Session Information */
#define KE2700_ATTR_LOGICAL_NAME                  IVI_ATTR_LOGICAL_NAME                   /* ViString, read-only  */
#define KE2700_ATTR_RESOURCE_DESCRIPTOR           IVI_ATTR_RESOURCE_DESCRIPTOR            /* ViString, read-only  */
#define KE2700_ATTR_IO_SESSION_TYPE               IVI_ATTR_IO_SESSION_TYPE                /* ViString, read-only  */
#define KE2700_ATTR_IO_SESSION                    IVI_ATTR_IO_SESSION                     /* ViSession, read-only */
    
    /*- Instrument-Specific Attributes -------------------------------------*/

    /*- Basic Instrument Operation -----------------------------------------*/

#define KE2700_ATTR_FUNCTION                   IVIDMM_ATTR_FUNCTION                    /* ViInt32      */
#define KE2700_ATTR_RANGE                      IVIDMM_ATTR_RANGE                       /* ViReal64     */
#define KE2700_ATTR_RESOLUTION_ABSOLUTE        IVIDMM_ATTR_RESOLUTION_ABSOLUTE
#define KE2700_ATTR_TRIGGER_SOURCE             IVIDMM_ATTR_TRIGGER_SOURCE              /* ViInt32      */
#define KE2700_ATTR_TRIGGER_DELAY              IVIDMM_ATTR_TRIGGER_DELAY               /* ViReal64     */

    /*- AC Measurment Extension Group --------------------------------------*/         
#define KE2700_ATTR_AC_MIN_FREQ                IVIDMM_ATTR_AC_MIN_FREQ                 /* ViReal64     */
#define KE2700_ATTR_AC_MAX_FREQ                IVIDMM_ATTR_AC_MAX_FREQ                 /* ViReal64     */

    /*- Device Info Extension Group ----------------------------------------*/ 
#define KE2700_ATTR_APERTURE_TIME              IVIDMM_ATTR_APERTURE_TIME               /* ViReal64,    */
#define KE2700_ATTR_APERTURE_TIME_UNITS        IVIDMM_ATTR_APERTURE_TIME_UNITS         /* ViInt32, read-only  */
                                                                            
    /*- Multi-Point Extension Group------------------------------------------*/      
#define KE2700_ATTR_SAMPLE_COUNT               IVIDMM_ATTR_SAMPLE_COUNT                /* ViInt32      */
#define KE2700_ATTR_SAMPLE_TRIGGER             IVIDMM_ATTR_SAMPLE_TRIGGER              /* ViInt32      */
#define KE2700_ATTR_SAMPLE_INTERVAL            IVIDMM_ATTR_SAMPLE_INTERVAL             /* ViReal64     */
#define KE2700_ATTR_TRIGGER_COUNT              IVIDMM_ATTR_TRIGGER_COUNT               /* ViInt32      */
#define KE2700_ATTR_MEAS_COMPLETE_DEST         IVIDMM_ATTR_MEAS_COMPLETE_DEST          /* ViInt32      */
    
    /*- Frequency Extension Group ------------------------------------------*/ 
#define KE2700_ATTR_FREQ_VOLTAGE_RANGE         IVIDMM_ATTR_FREQ_VOLTAGE_RANGE          /* ViReal64  */ 

     /*- Auto Range Value Extension Group -----------------------------------*/      
#define KE2700_ATTR_AUTO_RANGE_VALUE           IVIDMM_ATTR_AUTO_RANGE_VALUE            /* ViReal64, read-only */
    
     /*-Temperature Measurement Extension Group  -----------------------------*/      
#define KE2700_ATTR_TEMP_TRANSDUCER_TYPE       IVIDMM_ATTR_TEMP_TRANSDUCER_TYPE        /* ViInt32      */

     /*- Thermocouple Extension Group  --------------------------------------*/      
#define KE2700_ATTR_TEMP_TC_FIXED_REF_JUNC     IVIDMM_ATTR_TEMP_TC_FIXED_REF_JUNC      /* ViReal64     */ 
#define KE2700_ATTR_TEMP_TC_REF_JUNC_TYPE      IVIDMM_ATTR_TEMP_TC_REF_JUNC_TYPE       /* ViInt32      */
#define KE2700_ATTR_TEMP_TC_TYPE               IVIDMM_ATTR_TEMP_TC_TYPE                /* ViInt32      */

     /*- Auto Zero Extension Group -----------------------------------*/                
#define KE2700_ATTR_AUTO_ZERO                  IVIDMM_ATTR_AUTO_ZERO                   /* ViInt32      */

#define KE2700_ATTR_ID_QUERY_RESPONSE          (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1L)    /* ViString (Read Only) */
#define KE2700_ATTR_FREQ_THRESHOLD_VOLTAGE     (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 3L)
#define KE2700_ATTR_PERIOD_THRESHOLD_VOLTAGE   (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 4L)
#define KE2700_ATTR_TIMER_INTERVAL             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 5L)    /* ViReal64     */
#define KE2700_ATTR_DISPLAY_ENABLED            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 6L)
#define KE2700_ATTR_BEEPER_ENABLED             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 7L)
#define KE2700_ATTR_HOLD_ENABLED               (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 8L)
#define KE2700_ATTR_HOLD_WINDOW                (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 9L)    /* ViReal64     */
#define KE2700_ATTR_HOLD_COUNT                 (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 10L)   /* ViInt32      */
#define KE2700_ATTR_FILTER_ENABLED             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 11L)
#define KE2700_ATTR_FILTER_TYPE                (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 12L)   /* ViInt32      */
#define KE2700_ATTR_FILTER_COUNT               (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 13L)   /* ViInt32      */
#define KE2700_ATTR_RELATIVE_ENABLED           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 19L)
#define KE2700_ATTR_RELATIVE_REFERENCE         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 20L)   /* ViReal64     */
#define KE2700_ATTR_MATH_FUNCTION              (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 21L)   /* ViInt32      */
#define KE2700_ATTR_MATH_ENABLED               (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 22L)
#define KE2700_ATTR_MXB_M_FACTOR               (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 23L)   /* ViReal64     */
#define KE2700_ATTR_MXB_B_OFFSET               (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 24L)   /* ViReal64     */
#define KE2700_ATTR_PERCENT_REFERENCE          (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 26L)   /* ViReal64     */
#define KE2700_ATTR_BUF_STATISTICS_FORMAT      (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 27L)
#define KE2700_ATTR_BUF_STATISTICS_ENABLED     (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 28L)
#define KE2700_ATTR_ACV_DB_REFERENCE           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 29L)
#define KE2700_ATTR_DCV_DB_REFERENCE           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 31L)
#define KE2700_ATTR_ACV_UNITS                  (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 33L)
#define KE2700_ATTR_DCV_UNITS                  (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 34L)
#define KE2700_ATTR_LIMIT1_ENABLED             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 35L)
#define KE2700_ATTR_LIMIT1_UPPER_VALUE         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 36L)
#define KE2700_ATTR_LIMIT1_LOWER_VALUE         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 37L)

    
    /* specifies resolution in digits of precision and exists for backward compatibility. */
#define KE2700_ATTR_RESOLUTION                 IVIDMM_ATTR_RESOLUTION
// Keithley 2700 specific attributes
#define KE2700_ATTR_FILTER_WINDOW              (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 39L)
#define KE2700_ATTR_LIMIT2_ENABLED             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 40L)
#define KE2700_ATTR_LIMIT2_UPPER_VALUE         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 41L)
#define KE2700_ATTR_LIMIT2_LOWER_VALUE         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 42L)
#define KE2700_ATTR_LIMIT1_AUTO_CLEAR_ENABLED  (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 43L)
#define KE2700_ATTR_LIMIT2_AUTO_CLEAR_ENABLED  (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 44L)
#define KE2700_ATTR_CARD_SERIAL_NUMBER         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 46L)
#define KE2700_ATTR_CARD_TYPE                  (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 47L)
#define KE2700_ATTR_CARD_FW_VERSION            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 48L)
#define KE2700_ATTR_CARD_HAS_MUX               (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 49L)
#define KE2700_ATTR_CARD_HAS_ISOLATED_CHANNELS (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 50L)
#define KE2700_ATTR_CARD_HAS_BUILT_IN_CJC_SENSOR (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 51L)
#define KE2700_ATTR_CARD_MAX_VOLTAGE           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 52L)
#define KE2700_ATTR_CARD_2WIRE_START_CHAN      (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 53L)
#define KE2700_ATTR_CARD_2WIRE_END_CHAN        (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 54L)
#define KE2700_ATTR_CARD_AMPS_START_CHAN       (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 55L)
#define KE2700_ATTR_CARD_AMPS_END_CHAN         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 56L)
#define KE2700_ATTR_CARD_AO_START_CHAN         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 57L)
#define KE2700_ATTR_CARD_AO_END_CHAN           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 58L)
#define KE2700_ATTR_CARD_DO_START_CHAN         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 59L)
#define KE2700_ATTR_CARD_DO_END_CHAN           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 60L)
#define KE2700_ATTR_CARD_TOTALIZE_CHAN         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 61L)
#define KE2700_ATTR_TEMP_TC_SIMULATED_REF_JUNC (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 63L)
#define KE2700_ATTR_TEMP_TC_OPEN_DETECTOR_ENABLED (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 65L)
#define KE2700_ATTR_TEMP_FRTD_TYPE             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 69L)
#define KE2700_ATTR_TEMP_FRTD_USER_RZERO       (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 71L)
#define KE2700_ATTR_TEMP_FRTD_USER_ALPHA       (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 72L)
#define KE2700_ATTR_TEMP_FRTD_USER_BETA        (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 73L)
#define KE2700_ATTR_TEMP_FRTD_USER_DELTA       (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 74L)
#define KE2700_ATTR_LSYNC_ENABLED              (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 76L)
#define KE2700_ATTR_CHAN_RATIO_ENABLED         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 78L)
#define KE2700_ATTR_CHAN_RATIO_DELAY           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 79L)
#define KE2700_ATTR_CHAN_AVERAGE_DELAY         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 80L)
#define KE2700_ATTR_CHAN_AVERAGE_ENABLED       (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 81L)
#define KE2700_ATTR_ANALOG_OUTPUT_DCV          (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 83L)
#define KE2700_ATTR_POWERLINE_FREQ             IVIDMM_ATTR_POWERLINE_FREQ
#define KE2700_ATTR_TOTALIZE_TYPE              (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 85L)
#define KE2700_ATTR_TOTALIZE_EDGE              (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 86L)
#define KE2700_ATTR_DIGITAL_PORT_BYTE_VALUE    (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 88L)
#define KE2700_ATTR_DIGITAL_PORT_WORD_VALUE    (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 89L)
#define KE2700_ATTR_DIGITAL_OUTPUT_LEVEL       (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 91L)
#define KE2700_ATTR_DIGITAL_OUTPUT_ENABLED     (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 92L)
#define KE2700_ATTR_DIGITAL_OUTPUT_PULSE_WIDTH (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 94L)
#define KE2700_ATTR_DIGITAL_OUTPUT_PULSE_ENABLED (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 95L)
#define KE2700_ATTR_DIGITAL_OUTPUT_MASTER_LATCH_ENABLED (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 96L)
#define KE2700_ATTR_LIMIT1_TEST_FAIL           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 98L)
#define KE2700_ATTR_LIMIT2_TEST_FAIL           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 99L)
#define KE2700_ATTR_SYS_POWER_ON_SETUP         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 101L)
#define KE2700_ATTR_SYS_INPUT_SWITCH           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 102L)
#define KE2700_ATTR_KEY_CLICK_ENABLED          (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 103L)
#define KE2700_ATTR_SYS_TIME                   (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 104L)
#define KE2700_ATTR_SYS_DATE                   (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 105L)
#define KE2700_ATTR_SYS_SCPI_VERSION           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 106L)
#define KE2700_ATTR_SYS_NUMBER_OF_SLOTS        (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 107L)
#define KE2700_ATTR_SYS_KEY                    (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 108L)
#define KE2700_ATTR_BUF_AUTO_CLR_ENABLED       (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 109L)
#define KE2700_ATTR_BUF_SIZE                   (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 110L)
#define KE2700_ATTR_BUF_FREE_BYTES             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 111L)
#define KE2700_ATTR_BUF_TIMESTAMP_TYPE         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 113L)
#define KE2700_ATTR_BUF_TIMESTAMP_FORM         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 114L)
#define KE2700_ATTR_BUF_ELEMENTS               (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 115L)
#define KE2700_ATTR_BUF_DATA_SOURCE            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 116L)
#define KE2700_ATTR_BUF_DATA_CONTROL           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 117L)
#define KE2700_ATTR_BUF_DATA_FORMAT            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 118L)
#define KE2700_ATTR_BUF_BYTE_ORDER             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 119L)
#define KE2700_ATTR_BUF_POINTER_LOCATION       (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 120L)
#define KE2700_ATTR_MEASUREMENT_EVENT_ENABLE_REGISTER (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 122L)
#define KE2700_ATTR_MEASUREMENT_EVENT_REGISTER (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 123L)
#define KE2700_ATTR_MEASUREMENT_CONDITION_REGISTER (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 124L)
#define KE2700_ATTR_OPERATION_EVENT_REGISTER   (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 125L)
#define KE2700_ATTR_OPERATION_EVENT_ENABLE_REGISTER (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 126L)
#define KE2700_ATTR_OPERATION_CONDITION_REGISTER (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 127L)
#define KE2700_ATTR_QUESTIONABLE_EVENT_REGISTER (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 128L)
#define KE2700_ATTR_QUESTIONABLE_EVENT_ENABLE_REGISTER (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 129L)
#define KE2700_ATTR_QUESTIONABLE_CONDITION_REGISTER (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 130L)
#define KE2700_ATTR_MATH_UNIT                  (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 132L)
#define KE2700_ATTR_SCAN_CHANNEL_LIST          (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 134L)
#define KE2700_ATTR_SCAN_TRIGGER               (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 135L)
#define KE2700_ATTR_SCAN_ENABLED               (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 136L)
#define KE2700_ATTR_AUTOSCAN_ENABLED           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 137L)
#define KE2700_ATTR_MONITOR_CHANNEL            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 138L)
#define KE2700_ATTR_MONITOR_ENABLED            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 139L)
#define KE2700_ATTR_MONITOR_SCAN_POINTS        (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 140L)
#define KE2700_ATTR_CHANNEL_CLOSED             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 141L)
#define KE2700_ATTR_AUTO_CONFIGURE_ENABLED     (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 146L)
#define KE2700_ATTR_DCV_INPUT_DIVIDER_ENABLED  (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 147L)
#define KE2700_ATTR_CONTINUOUS_INIT_ON         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 149L)
#define KE2700_ATTR_BUF_INUSE_BYTES            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 151L)
#define KE2700_ATTR_TEMP_UNIT                  (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 155L)
#define KE2700_ATTR_OFFSET_COMPENSATION_ENABLED (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 157L)
#define KE2700_ATTR_CONTINUITY_THRESHOLD_RESISTANCE (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 159L)
#define KE2700_ATTR_MESSAGE_ENABLED            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 163L)
#define KE2700_ATTR_DISPLAY_MESSAGE            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 164L)
#define KE2700_ATTR_DIGITAL_PORT_DWORD_VALUE   (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 166L)
#define KE2700_ATTR_DIGITAL_PORT_VALUE_FORMAT  (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 167L)
#define KE2700_ATTR_DIGITAL_PORT_STATE         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 168L)
#define KE2700_ATTR_DIGITAL_PORT_DATA_LENGTH   (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 170L)
#define KE2700_ATTR_DRY_CIRCUIT_4W_RES_ENABLED (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 172L)
#define KE2700_ATTR_CHANNEL_COUNT              (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 174L)
#define KE2700_ATTR_CHANNEL_NAMES              (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 175L)
#define KE2700_ATTR_STANDARD_EVENT_REGISTER    (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 179L)
#define KE2700_ATTR_STANDARD_EVENT_ENABLE_REGISTER (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 180L)
#define KE2700_ATTR_CALIBRATION_LOCKED         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 182L)
#define KE2700_ATTR_CALIBRATION_DATE           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 183L)
#define KE2700_ATTR_CALIBRATION_COUNT          (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 184L)
#define KE2700_ATTR_CALIBRATION_CODE           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 185L)
#define KE2700_ATTR_CALIBRATION_COUNT_RESET    (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 186L)
#define KE2700_ATTR_CALIBRATION_INITIATE       (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 187L)
#define KE2700_ATTR_CALIBRATION_SAVE           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 188L)
#define KE2700_ATTR_CALIBRATION_TEMPERATURE    (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 189L)
#define KE2700_ATTR_CALIBRATION_DAC            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 190L)
#define KE2700_ATTR_SETUP_SAVE                 (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 192L)
#define KE2700_ATTR_SETUP_RECALL               (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 193L)
#define KE2700_ATTR_ERROR_QUEUE_NEXT           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 195L)
#define KE2700_ATTR_ENABLED_ERRORS             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 196L)
#define KE2700_ATTR_DISABLED_ERRORS            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 197L)
#define KE2700_ATTR_ERROR_QUEUE_CLEAR          (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 198L)
#define KE2700_ATTR_CLEAR_EVENT_REGISTERS      (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 200L)
#define KE2700_ATTR_RESET_ENABLE_REGISTERS     (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 201L)
#define KE2700_ATTR_SERVICE_REQUEST_ENABLE_REGISTER (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 203L)
#define KE2700_ATTR_STATUS_BYTE_REGISTER       (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 204L)
#define KE2700_ATTR_CHANNEL_LIST            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 206L)
#define KE2700_ATTR_SERVICE_REQUEST_EVENT   (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 208L)
#define KE2700_ATTR_FRONT_PANEL_LOCKOUT     (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 210L)
#define KE2700_ATTR_SERIAL_BAUD             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 212L)
#define KE2700_ATTR_SERIAL_PACE             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 214L)
#define KE2700_ATTR_SERIAL_TERMINATOR       (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 215L)
#define KE2700_ATTR_SERIAL_CONTROL          (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 216L)
#define KE2700_ATTR_SERIAL_SEND_SCPI        (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 217L)
#define KE2700_ATTR_SERIAL_QUERY            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 218L)
#define KE2700_ATTR_IP_ADDRESS              (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 219L)
#define KE2700_ATTR_SUBNET_MASK             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 220L)
#define KE2700_ATTR_GATEWAY                 (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 221L)
#define KE2700_ATTR_DHCP_ENABLED            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 222L)
#define KE2700_ATTR_MAC_ADDRESS             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 223L)
#define KE2700_ATTR_BATTERY_PRESENT         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 224L)
#define KE2700_ATTR_BATTERY_STATUS          (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 225L)
#define KE2700_ATTR_PASSWORD_LOCKED         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 226L)
#define KE2700_ATTR_PASSWORD_ENABLED        (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 227L)
#define KE2700_ATTR_PASSWORD_SET            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 228L)
#define KE2700_ATTR_PASSWORD_UNLOCK         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 229L)
#define KE2700_ATTR_COMMON_SIDE_4W_OHMS_ENABLED (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 231L)
#define KE2700_ATTR_TRIGGER_SLOPE           IVIDMM_ATTR_TRIGGER_SLOPE
#define KE2700_ATTR_TEMP_RTD_ALPHA          IVIDMM_ATTR_TEMP_RTD_ALPHA
#define KE2700_ATTR_TEMP_RTD_RES            IVIDMM_ATTR_TEMP_RTD_RES
#define KE2700_ATTR_TEMP_THERMISTOR_RES     IVIDMM_ATTR_TEMP_THERMISTOR_RES



/**************************************************************************** 
 *------------------------ Attribute Value Defines -------------------------* 
 ****************************************************************************/

    /*- Defined values for attribute KE2700_ATTR_FUNCTION -*/

#define KE2700_VAL_DC_VOLTS              IVIDMM_VAL_DC_VOLTS    
#define KE2700_VAL_AC_VOLTS              IVIDMM_VAL_AC_VOLTS    
#define KE2700_VAL_DC_CURRENT            IVIDMM_VAL_DC_CURRENT  
#define KE2700_VAL_AC_CURRENT            IVIDMM_VAL_AC_CURRENT  
#define KE2700_VAL_2_WIRE_RES            IVIDMM_VAL_2_WIRE_RES  
#define KE2700_VAL_4_WIRE_RES            IVIDMM_VAL_4_WIRE_RES           
#define KE2700_VAL_FREQ                  IVIDMM_VAL_FREQ                 
#define KE2700_VAL_PERIOD                IVIDMM_VAL_PERIOD               
#define KE2700_VAL_TEMPERATURE           IVIDMM_VAL_TEMPERATURE           
#define KE2700_VAL_CONTINUITY            (IVIDMM_VAL_FUNC_SPECIFIC_EXT_BASE + 4L)


    /*- Defined values for attribute KE2700_ATTR_RANGE -*/
        
#define KE2700_VAL_AUTO_RANGE_ON         IVIDMM_VAL_AUTO_RANGE_ON            
#define KE2700_VAL_AUTO_RANGE_OFF        IVIDMM_VAL_AUTO_RANGE_OFF           

 
    /*- Defined values for attribute KE2700_ATTR_TRIGGER_SOURCE -*/

#define KE2700_VAL_IMMEDIATE             IVIDMM_VAL_IMMEDIATE
#define KE2700_VAL_EXTERNAL              IVIDMM_VAL_EXTERNAL 
#define KE2700_VAL_SOFTWARE_TRIG         IVIDMM_VAL_SOFTWARE_TRIG 
#define KE2700_VAL_TIMER                 IVIDMM_VAL_INTERVAL

    /*- Defined values for attribute KE2700_ATTR_AUTO_ZER0 -*/
    
#define KE2700_VAL_AUTO_ZERO_OFF         IVIDMM_VAL_AUTO_ZERO_OFF    
#define KE2700_VAL_AUTO_ZERO_ON          IVIDMM_VAL_AUTO_ZERO_ON     

    /* Defined value for attribute KE2700_ATTR_SAMPLE_TRIGGER -*/
    
#define KE2700_VAL_INTERVAL              IVIDMM_VAL_INTERVAL

    /*- Defined values for attribute KE2700_ATTR_TRIGGER_DELAY -*/
    
#define KE2700_VAL_AUTO_DELAY_ON         IVIDMM_VAL_AUTO_DELAY_ON    
#define KE2700_VAL_AUTO_DELAY_OFF        IVIDMM_VAL_AUTO_DELAY_OFF   

    /*- Defined values for attribute KE2700_ATTR_APERTURE_TIME_UNITS -*/
    
#define KE2700_VAL_SECONDS               IVIDMM_VAL_SECONDS          
#define KE2700_VAL_POWER_LINE_CYCLES     IVIDMM_VAL_POWER_LINE_CYCLES

    /*- Attribute Values for KE2700_ATTR_TEMP_TRANSDUCER_TYPE------------*/
#define KE2700_VAL_THERMOCOUPLE          IVIDMM_VAL_THERMOCOUPLE
#define KE2700_VAL_THERMISTOR            IVIDMM_VAL_THERMISTOR
#define KE2700_VAL_2_WIRE_RTD            IVIDMM_VAL_2_WIRE_RTD
#define KE2700_VAL_4_WIRE_RTD            IVIDMM_VAL_4_WIRE_RTD

    /*- Attribute Values for KE2700_ATTR_TEMP_TC_REF_JUNC_TYPE------------*/
#define KE2700_VAL_TEMP_REF_JUNC_INTERNAL IVIDMM_VAL_TEMP_REF_JUNC_INTERNAL
#define KE2700_VAL_TEMP_REF_JUNC_FIXED    IVIDMM_VAL_TEMP_REF_JUNC_FIXED

    /*- Attribute values for KE2700_ATTR_TEMP_TC_TYPE -*/
    
#define KE2700_VAL_TEMP_TC_J             IVIDMM_VAL_TEMP_TC_J
#define KE2700_VAL_TEMP_TC_K             IVIDMM_VAL_TEMP_TC_K
#define KE2700_VAL_TEMP_TC_T             IVIDMM_VAL_TEMP_TC_T
#define KE2700_VAL_TEMP_TC_E             IVIDMM_VAL_TEMP_TC_E
#define KE2700_VAL_TEMP_TC_R             IVIDMM_VAL_TEMP_TC_R
#define KE2700_VAL_TEMP_TC_S             IVIDMM_VAL_TEMP_TC_S
#define KE2700_VAL_TEMP_TC_B             IVIDMM_VAL_TEMP_TC_B
#define KE2700_VAL_TEMP_TC_N             IVIDMM_VAL_TEMP_TC_N


    /*- Attribute values for KE2700_ATTR_THERMO_RJUNCTION -*/
    
#define KE2700_VAL_THERMO_REAL           0
#define KE2700_VAL_THERMO_SIMULATED      1

    /*- Attribute values for KE2700_ATTR_ACV_UNITS and KE2700_ATTR_DCV_UNITS -*/
    
#define KE2700_VAL_UNITS_V               1
#define KE2700_VAL_UNITS_DB              2
#define KE2700_VAL_UNITS_REL_DB          3

    /*- Attribute values for KE2700_ATTR_MATH_FUNCTION -*/
    
#define KE2700_VAL_MATH_NONE             1
#define KE2700_VAL_MATH_MXB              2
#define KE2700_VAL_MATH_PERCENT          3

    /*- Attribute values for KE2700_ATTR_FILTER_TYPE -*/
    
#define KE2700_VAL_FILTER_MOVING         1
#define KE2700_VAL_FILTER_REPEATING      2


   /*- Defined values for attribute KE2700_ATTR_RESOLUTION -*/

#define KE2700_VAL_3_5_DIGITS            3.5
#define KE2700_VAL_4_5_DIGITS            4.5
#define KE2700_VAL_5_5_DIGITS            5.5
#define KE2700_VAL_6_5_DIGITS            6.5

/**************************************************************************** 
 *------------------------------ Useful Macros -----------------------------* 
 ****************************************************************************/

    /* Defined values for maxTime parameter to the Measure, Read, and Fetch functions */
#define KE2700_VAL_MAX_TIME_INFINITE           IVIDMM_VAL_MAX_TIME_INFINITE
#define KE2700_VAL_MAX_TIME_IMMEDIATE          IVIDMM_VAL_MAX_TIME_IMMEDIATE

/*- Attribute Values generated by CVI on 8/4/00 at 11:25 AM -------------*/
#define KE2700_VAL_CARD_NONE                                        0
#define KE2700_VAL_CARD_7700                                        7700
#define KE2700_VAL_CARD_7701                                        7701
#define KE2700_VAL_CARD_7702                                        7702
#define KE2700_VAL_CARD_7703                                        7703
#define KE2700_VAL_CARD_7705                                        7705
#define KE2700_VAL_CARD_7706                                        7706
#define KE2700_VAL_CARD_7707                                        7707
#define KE2700_VAL_CARD_7708                                        7708
#define KE2700_VAL_CARD_7709                                        7709
#define KE2700_VAL_CARD_7710                                        7710
#define KE2700_VAL_CARD_7711                                        7711
#define KE2700_VAL_CARD_7712                                        7712


/*- Attribute Values generated by CVI on 8/9/00 at 4:44 PM --------------*/
#define KE2700_VAL_THERMO_INTERNAL                                  2
#define KE2700_VAL_THERMO_EXTERNAL                                  3

/*- Attribute Values generated by CVI on 8/9/00 at 4:53 PM --------------*/
#define KE2700_VAL_TC_REF_INTERNAL                                  1
#define KE2700_VAL_TC_REF_SIMULATED                                 2
#define KE2700_VAL_TC_REF_EXTERNAL                                  3

/*- Attribute Values generated by CVI on 8/10/00 at 9:56 AM -------------*/
#define KE2700_VAL_TEMP_FRTD_PT100                                  1
#define KE2700_VAL_TEMP_FRTD_D100                                   2
#define KE2700_VAL_TEMP_FRTD_F100                                   3
#define KE2700_VAL_TEMP_FRTD_PT3916                                 4
#define KE2700_VAL_TEMP_FRTD_PT385                                  5
#define KE2700_VAL_TEMP_FRTD_USER                                   6

/*- Attribute Values generated by CVI on 8/10/00 at 10:51 AM ------------*/
#define KE2700_VAL_MANUAL                                           1002

/*- Attribute Values generated by CVI on 8/15/00 at 12:21 PM ------------*/
#define KE2700_VAL_TOTALIZE_READ                                    1
#define KE2700_VAL_TOTALIZE_RESET                                   2

/*- Attribute Values generated by CVI on 8/16/00 at 4:47 PM -------------*/
#define KE2700_VAL_EDGE_RISING                         IVIDMM_VAL_POSITIVE
#define KE2700_VAL_EDGE_FALLING                        IVIDMM_VAL_NEGATIVE

/*- Attribute Values generated by CVI on 8/15/00 at 3:10 PM -------------*/
#define KE2700_VAL_DO_LEVEL_HIGH                                    1
#define KE2700_VAL_DO_LEVEL_LOW                                     0

/*- Attribute Values generated by CVI on 8/16/00 at 1:08 PM -------------*/
#define KE2700_VAL_PWR_ON_RST                                       1
#define KE2700_VAL_PWR_ON_PRESET                                    2
#define KE2700_VAL_PWR_ON_SAV0                                      3
#define KE2700_VAL_PWR_ON_SAV1                                      4
#define KE2700_VAL_PWR_ON_SAV2                                      5
#define KE2700_VAL_PWR_ON_SAV3                                      6

/*- Attribute Values generated by CVI on 8/16/00 at 4:47 PM -------------*/
#define KE2700_VAL_INPUT_REAR                                       0
#define KE2700_VAL_INPUT_FRONT                                      1

/*- Attribute Values generated by CVI on 8/16/00 at 4:38 PM -------------*/
#define KE2700_VAL_TIMESTAMP_RELATIVE                               1
#define KE2700_VAL_TIMESTAMP_RTCLOCK                                2

/*- Attribute Values generated by CVI on 8/16/00 at 4:47 PM -------------*/
#define KE2700_VAL_TIMESTAMP_ABS                                    1
#define KE2700_VAL_TIMESTAMP_DELTA                                  2

/*- Attribute Values generated by CVI on 8/16/00 at 4:47 PM -------------*/
#define KE2700_VAL_ELEMENT_READING                                  1
#define KE2700_VAL_ELEMENT_CHAN                                     2
#define KE2700_VAL_ELEMENT_RNUM                                     4
#define KE2700_VAL_ELEMENT_TSTAMP                                   8
#define KE2700_VAL_ELEMENT_LIMIT                                    16
#define KE2700_VAL_ELEMENT_UNIT                                     32

/*- Attribute Values generated by CVI on 8/16/00 at 4:47 PM -------------*/
#define KE2700_VAL_DATA_SENSE                                       1
#define KE2700_VAL_DATA_CALC                                        2
#define KE2700_VAL_DATA_NONE                                        3

/*- Attribute Values generated by CVI on 8/16/00 at 4:47 PM -------------*/
#define KE2700_VAL_CONTROL_NEVER                                    1
#define KE2700_VAL_CONTROL_NEXT                                     2
#define KE2700_VAL_CONTROL_ALWAYS                                   3

/*- Attribute Values generated by CVI on 8/16/00 at 4:47 PM -------------*/
#define KE2700_VAL_STATS_NONE                                       0
#define KE2700_VAL_STATS_MEAN                                       1
#define KE2700_VAL_STATS_SDEV                                       2
#define KE2700_VAL_STATS_MIN                                        3
#define KE2700_VAL_STATS_MAX                                        4
#define KE2700_VAL_STATS_PK2PK                                      5

/*- Attribute Values generated by CVI on 8/16/00 at 4:47 PM -------------*/
#define KE2700_VAL_FORMAT_ASCII                                     1
#define KE2700_VAL_FORMAT_SINGLE                                    2
#define KE2700_VAL_FORMAT_SINGLE32                                  3
#define KE2700_VAL_FORMAT_DOUBLE                                    4
#define KE2700_VAL_FORMAT_DOUBLE64                                  5

/*- Attribute Values generated by CVI on 8/16/00 at 4:47 PM -------------*/
#define KE2700_VAL_BYTE_ORDER_NORMAL                                1
#define KE2700_VAL_BYTE_ORDER_SWAPPED                               2

/*- Attribute Values generated by CVI on 8/17/00 at 1:54 PM -------------*/
#define KE2700_VAL_SCAN_TRIGGER_IMM                                 0
#define KE2700_VAL_SCAN_TRIGGER_HLIM1                               1
#define KE2700_VAL_SCAN_TRIGGER_LLIM1                               2
#define KE2700_VAL_SCAN_TRIGGER_HLIM2                               4
#define KE2700_VAL_SCAN_TRIGGER_LLIM2                               8


/*- Attribute Values generated by CVI on 8/18/00 at 2:47 PM -------------*/
#define KE2700_VAL_COMMUNICATE_BUS_232                              1
#define KE2700_VAL_COMMUNICATE_BUS_GPIB                             2


    /*- Define values for type parameter to ConvertTemperature function -----------*/ 
#define KE2700_TEMP_TYPE_F               1 
#define KE2700_TEMP_TYPE_K               2 

/**************************************************************************** 
 *---------------- Instrument Driver Function Declarations -----------------* 
 ****************************************************************************/

    /*- Init and Close Functions -------------------------------------------*/
    
ViStatus _VI_FUNC  KE2700_init (ViRsrc resourceName, ViBoolean IDQuery,
                                 ViBoolean resetDevice, ViSession *vi);
ViStatus _VI_FUNC  KE2700_InitWithOptions (ViRsrc resourceName, ViBoolean IDQuery,
                                            ViBoolean resetDevice, ViString optionString, 
                                            ViSession *newVi);

ViStatus _VI_FUNC KE2700_GetCardInfo (ViSession instrumentHandle,
                                      ViConstString slot, ViChar model[],
                                      ViInt32 *serilalNo,
                                      ViChar firmwareVersion[],
                                      ViBoolean *hasMUX, ViBoolean *hasIsoChan,
                                      ViBoolean *hasCJC_sensor,
                                      ViReal64 *maxVolt);

ViStatus _VI_FUNC KE2700_GetCardChan (ViSession instrumentHandle,
                                      ViConstString slot, ViInt32 *startChannel,
                                      ViInt32 *endChannel,
                                      ViInt32 *ampsStartChannel,
                                      ViInt32 *ampsEndChannel,
                                      ViInt32 *AOStartChannel,
                                      ViInt32 *AOEndChannel,
                                      ViInt32 *DOStartChannel,
                                      ViInt32 *DOEndChannel,
                                      ViInt32 *totalizerChannel);

ViStatus _VI_FUNC KE2700_InstallPseudoCard (ViSession instrumentHandle,
                                            ViConstString slot, ViString model);

ViStatus _VI_FUNC KE2700_SetChannelList (ViSession instrumentHandle,
                                         ViChar channelList[]);

ViStatus _VI_FUNC KE2700_GetChannelList (ViSession instrumentHandle,
                                         ViInt32 arraySize, ViChar channelList[]);

ViStatus _VI_FUNC  KE2700_close (ViSession vi);   

    /*- Coercion Functions --------------------------------------------------*/
ViStatus _VI_FUNC KE2700_GetNextCoercionRecord (ViSession vi, ViInt32 bufferSize, ViChar record[]);

    /*- Locking Functions --------------------------------------------------*/
    
ViStatus _VI_FUNC  KE2700_LockSession (ViSession vi, ViBoolean *callerHasLock);   
ViStatus _VI_FUNC  KE2700_UnlockSession (ViSession vi, ViBoolean *callerHasLock);


    /*- Basic Instrument Operation -----------------------------------------*/
    
ViStatus _VI_FUNC  KE2700_ConfigureMeasurement (ViSession vi, ViInt32 measFunction,      
                                              ViReal64 range, ViReal64 resolution);

ViStatus _VI_FUNC KE2700_ConfigureSimRefJunction (ViSession vi,
                                                  ViReal64 fixedReferenceJunction);

ViStatus _VI_FUNC  KE2700_ConfigureTrigger (ViSession vi, ViInt32 triggerSource,
                                             ViReal64 triggerDelay);

ViStatus _VI_FUNC KE2700_ConfigureSwitches (ViSession vi, ViChar channelList[],
                                              ViInt32 switchMode);

ViStatus _VI_FUNC KE2700_GetSwitches (ViSession vi, ViChar channelList[],
                                        ViInt32 switchListLength,
                                        ViChar switchList[], ViInt32 getMode);

ViStatus _VI_FUNC  KE2700_Read (ViSession vi, ViInt32 maxTime, ViReal64 *reading);
ViStatus _VI_FUNC  KE2700_Fetch (ViSession vi, ViInt32 maxTime, ViReal64 *reading);

ViStatus _VI_FUNC KE2700_FetchMultiReading (ViSession vi,
                                            ViInt32 start, ViInt32 length,
                                            ViInt32 arraySize,
                                            ViReal64 readingArray[],
                                            ViInt32 *actualPoints);

ViStatus _VI_FUNC KE2700_FetchMultiReadingChar (ViSession vi, ViInt32 start, ViInt32 length,
                                                 ViInt32 arraySize, ViChar readingArray[],
                                                 ViInt32 *actPoints);

ViStatus _VI_FUNC KE2700_FetchMultiPointChar (ViSession instrumentHandle,
                                              ViInt32 maximumTime_ms,
                                              ViInt32 arraySize,
                                              ViChar readingArray[],
                                              ViInt32 *actualNumber_ofPoints);

ViStatus _VI_FUNC  KE2700_Abort (ViSession vi);
ViStatus _VI_FUNC  KE2700_Initiate (ViSession vi);
ViStatus _VI_FUNC KE2700_ConfigureApertureTimeInfo (ViSession vi, ViReal64 apertureTime, ViInt32  apertureTimeUnit);

/*- AC Measurment Extension Group --------------------------------------*/  
ViStatus _VI_FUNC  KE2700_ConfigureACBandwidth (ViSession vi, ViReal64 minFreq,   
                                                ViReal64 maxFreq);                
                                             
    /*- Frequency Extension Group ------------------------------------------*/ 
ViStatus _VI_FUNC  KE2700_ConfigureFrequencyVoltageRange (ViSession vi, 
                                                          ViReal64 frequencyVoltageRange); 

ViStatus _VI_FUNC KE2700_ConfigureTriggerSlope (ViSession instrumentHandle,
                                                ViInt32 triggerSlope);

ViStatus _VI_FUNC KE2700_ConfigureMonitorChannel (ViSession vi,
                                           ViChar monitorChannel[],
                                           ViInt32 monitorScanPoints,
                                           ViInt32 scanTrigger);

     /*- Multi-Point Extension Group------------------------------------------*/  
    
ViStatus _VI_FUNC  KE2700_ConfigureMultiPoint (ViSession vi, 
                                                ViInt32 triggerCount, 
                                                ViInt32 sampleCount, 
                                                ViInt32 sampleTrigger, 
                                                ViReal64 sampleInterval);
ViStatus _VI_FUNC  KE2700_ConfigureMeasCompleteDest (ViSession vi, 
                                                     ViInt32 measCompleteDest);
ViStatus _VI_FUNC  KE2700_ReadMultiPoint (ViSession vi, ViInt32 maxTime, 
                                           ViInt32 arraySize, 
                                           ViReal64 readingArray[], 
                                           ViInt32 *actualPts);
ViStatus _VI_FUNC  KE2700_FetchMultiPoint (ViSession vi, 
                                            ViInt32 maxTime, ViInt32 arraySize, 
                                            ViReal64 readingArray[], 
                                            ViInt32 *actualPts);

    /*- Device Info Extension Group ----------------------------------------*/                                                 
ViStatus _VI_FUNC   KE2700_GetApertureTimeInfo (ViSession vi, ViReal64 *apertureTime, 
                                              ViInt32 *apertureTimeUnits);

    /*- Auto Range Value Extension Group -----------------------------------*/                                              
ViStatus _VI_FUNC   KE2700_GetAutoRangeValue (ViSession vi, ViReal64 *autoRangeValue);                                               

    /*- Auto Zero Extension Group -----------------------------------*/
ViStatus _VI_FUNC   KE2700_ConfigureAutoZeroMode (ViSession vi, ViInt32 autoZeroMode);

    /*-Temperature Measurement Extension Group  -----------------------------*/      
ViStatus _VI_FUNC   KE2700_ConfigureTransducerType (ViSession vi,ViInt32 transducerType);
                                                    
ViStatus _VI_FUNC KE2700_ConfigureThermistor (ViSession vi, ViReal64 thermistortype);

ViStatus _VI_FUNC KE2700_ConfigureRTD (ViSession instrumentHandle,
                                       ViReal64 alpha, ViReal64 resistance);

ViStatus _VI_FUNC KE2700_ConfigureFRTDType (ViSession vi, ViInt32 RTDType);

ViStatus _VI_FUNC KE2700_ConfigureUserFRTD (ViSession vi,
                                            ViReal64 r0, ViReal64 alpha,
                                            ViReal64 beta, ViReal64 delta);

    /*- Thermocouple Extension Group  --------------------------------------*/ 
ViStatus _VI_FUNC   KE2700_ConfigureFixedRefJunction (ViSession vi, ViReal64 fixedRefJunction);
ViStatus _VI_FUNC   KE2700_ConfigureThermocouple (ViSession vi,
                                                  ViInt32 thermocoupleType,
                                                  ViInt32 refJunctionType);
    
    /*- Software Trigger Extension Group -----------------------------------*/                                               
ViStatus _VI_FUNC  KE2700_SendSoftwareTrigger (ViSession vi);                                         
                                                   
    /*- Error Functions ----------------------------------------------------*/
    
ViStatus _VI_FUNC  KE2700_error_query (ViSession vi, ViInt32 *errorCode, ViChar errorMessage[]);
ViStatus _VI_FUNC  KE2700_GetErrorInfo (ViSession vi, ViStatus *primaryError, 
                                         ViStatus *secondaryError, 
                                         ViChar errorElaboration[256]);
ViStatus _VI_FUNC  KE2700_ClearErrorInfo (ViSession vi);
ViStatus _VI_FUNC  KE2700_error_message (ViSession vi, ViStatus errorCode, ViChar errorMessage[256]);

ViStatus _VI_FUNC KE2700_FetchTotalizer (ViSession instrumentHandle,
                                        ViInt32 maximumTime_ms, ViInt32 *reading);

ViStatus _VI_FUNC KE2700_WriteVolts (ViSession instrumentHandle, ViReal64 volt);

ViStatus _VI_FUNC KE2700_ReadPort (ViSession instrumentHandle, ViInt32 portWidth,
                                   ViInt32 *portValue);

ViStatus _VI_FUNC KE2700_WritePort (ViSession instrumentHandle,
                                    ViInt32 portWidth, ViInt32 portValue);


    /*- Utility Functions --------------------------------------------------*/
    
ViStatus _VI_FUNC  KE2700_reset (ViSession vi);
ViStatus _VI_FUNC  KE2700_self_test (ViSession vi, ViInt16 *selfTestResult,
                                      ViChar selfTestMessage[]);
ViStatus _VI_FUNC  KE2700_revision_query (ViSession vi, 
                                           ViChar instrumentDriverRevision[],
                                           ViChar firmwareRevision[]);
                                           
ViStatus _VI_FUNC KE2700_GetError (ViSession vi, 
                                   ViStatus *errorCode, 
                                   ViInt32 bufferSize,
                                   ViChar description[]);
ViStatus _VI_FUNC KE2700_ClearError (ViSession vi);
ViStatus _VI_FUNC KE2700_Disable (ViSession vi);
ViStatus _VI_FUNC KE2700_ResetWithDefaults (ViSession vi);
ViStatus _VI_FUNC KE2700_InvalidateAllAttributes (ViSession vi);
ViStatus _VI_FUNC KE2700_ClearInterchangeWarnings (ViSession vi);
ViStatus _VI_FUNC KE2700_ResetInterchangeCheck (ViSession vi);
ViStatus _VI_FUNC KE2700_GetNextInterchangeWarning (ViSession vi, 
                                                    ViInt32 bufferSize, 
                                                    ViChar warnString[]);

ViStatus _VI_FUNC  KE2700_WriteInstrData (ViSession vi, ViConstString writeBuffer); 
ViStatus _VI_FUNC  KE2700_ReadInstrData  (ViSession vi, ViInt32 numBytes, 
                                           ViChar rdBuf[], ViInt32 *bytesRead);
ViStatus _VI_FUNC  KE2700_IsOverRange (ViSession vi,
                                        ViReal64 measurementValue,
                                        ViBoolean *isOverRange);
                                        
ViStatus _VI_FUNC KE2700_Reconnect (ViRsrc resourceName, ViSession *intrumentHandle);
ViStatus _VI_FUNC KE2700_GetBufferInfo (ViSession instrumentHandle,ViInt32 *timestamptype, ViInt32 *count);
ViStatus _VI_FUNC KE2700_FetchBufferData(ViSession vi, ViInt32 format, ViInt32 start, ViInt32 count,
										   ViInt32 bytesSize, ViChar pBuf[], ViInt32 *bytesRead);
ViStatus _VI_FUNC KE2700_Disconnect (ViSession instrumentHandle);										   

    /*- Instrument Specific --------------------------------------------------*/

ViStatus _VI_FUNC  KE2700_ConfigureMath (ViSession vi, ViInt32 function, 
                                           ViBoolean state);
ViStatus _VI_FUNC  KE2700_ConfigureMathMXB (ViSession vi, ViReal64 m, 
                                              ViReal64 b);
ViStatus _VI_FUNC  KE2700_ConfigureMathPercent (ViSession vi, ViReal64 percent);
ViStatus _VI_FUNC  KE2700_ConfigureHold (ViSession vi, ViReal64 window, 
                                          ViInt32 count, ViBoolean state);

ViStatus _VI_FUNC KE2700_ConfigurePowerLineFrequency (ViSession instrumentHandle,
                                                      ViReal64 powerLineFrequency);

ViStatus _VI_FUNC  KE2700_ConfigureFilter (ViSession vi, ViInt32 filtertype, ViInt32 count, 
												ViReal64 window, ViBoolean enabled);
ViStatus _VI_FUNC  KE2700_ConfigureRelative (ViSession vi, ViReal64 reference, 
                                              ViBoolean enabled);

ViStatus _VI_FUNC KE2700_ConfigureChanRatio (ViSession vi, ViReal64 delay, ViBoolean enabled);

ViStatus _VI_FUNC KE2700_ConfigureChanAverage (ViSession vi, ViReal64 delay, ViBoolean enabled);

ViStatus _VI_FUNC KE2700_ConfigureDO(ViSession vi,  ViInt32 level, ViBoolean masterLatched,
									 ViBoolean DOState, ViBoolean pulseState, ViReal64 pulseWidth);
									
ViStatus _VI_FUNC KE2700_ConfigureVoltDB (ViSession vi, ViInt32 unit, ViReal64 reference);

ViStatus _VI_FUNC KE2700_ConfigureTotalizer (ViSession vi, ViInt32 type, ViInt32 edge);

ViStatus _VI_FUNC  KE2700_ConfigureMultiPointStats (ViSession vi, ViInt32 function, ViBoolean state);
ViStatus _VI_FUNC KE2700_ConfigureLimit(ViSession vi, ViInt32 limitIndex,
                                        ViReal64 upperLimit,ViReal64 lowerLimit, ViBoolean state);
ViStatus _VI_FUNC  KE2700_AcquireNewMathPercentReference (ViSession vi);
ViStatus _VI_FUNC  KE2700_AcquireNewRelativeReference (ViSession vi);
ViStatus _VI_FUNC  KE2700_FetchMultiPointStats (ViSession vi, ViInt32 maxTime, ViReal64 *data);
ViStatus _VI_FUNC  KE2700_FetchLimitTestData (ViSession vi, ViBoolean *failUpperLimit1,
					ViBoolean *failLowerLimit1,ViBoolean *failUpperLimit2,ViBoolean *failLowerLimit2);
					
ViStatus _VI_FUNC  KE2700_GetChannelName (ViSession vi, ViInt32 index, ViInt32 BufSize, ViChar name[]);

    /*- Set, Get, and Check Attribute Functions ----------------------------*/
    
ViStatus _VI_FUNC  KE2700_GetAttributeViInt32 (ViSession vi, ViConstString channelName, ViAttr attribute, ViInt32 *value);
ViStatus _VI_FUNC  KE2700_GetAttributeViReal64 (ViSession vi, ViConstString channelName, ViAttr attribute, ViReal64 *value);
ViStatus _VI_FUNC  KE2700_GetAttributeViString (ViSession vi, ViConstString channelName, ViAttr attribute, ViInt32 bufSize, ViChar value[]); 
ViStatus _VI_FUNC  KE2700_GetAttributeViSession (ViSession vi, ViConstString channelName, ViAttr attribute, ViSession *value);
ViStatus _VI_FUNC  KE2700_GetAttributeViBoolean (ViSession vi, ViConstString channelName, ViAttr attribute, ViBoolean *value);

ViStatus _VI_FUNC  KE2700_SetAttributeViInt32 (ViSession vi, ViConstString channelName, ViAttr attribute, ViInt32 value);
ViStatus _VI_FUNC  KE2700_SetAttributeViReal64 (ViSession vi, ViConstString channelName, ViAttr attribute, ViReal64 value);
ViStatus _VI_FUNC  KE2700_SetAttributeViString (ViSession vi, ViConstString channelName, ViAttr attribute, ViConstString value); 
ViStatus _VI_FUNC  KE2700_SetAttributeViSession (ViSession vi, ViConstString channelName, ViAttr attribute, ViSession value);
ViStatus _VI_FUNC  KE2700_SetAttributeViBoolean (ViSession vi, ViConstString channelName, ViAttr attribute, ViBoolean value);

ViStatus _VI_FUNC  KE2700_CheckAttributeViInt32 (ViSession vi, ViConstString channelName, ViAttr attribute, ViInt32 value);
ViStatus _VI_FUNC  KE2700_CheckAttributeViReal64 (ViSession vi, ViConstString channelName, ViAttr attribute, ViReal64 value);
ViStatus _VI_FUNC  KE2700_CheckAttributeViString (ViSession vi, ViConstString channelName, ViAttr attribute, ViConstString value); 
ViStatus _VI_FUNC  KE2700_CheckAttributeViSession (ViSession vi, ViConstString channelName, ViAttr attribute, ViSession value);
ViStatus _VI_FUNC  KE2700_CheckAttributeViBoolean (ViSession vi, ViConstString channelName, ViAttr attribute, ViBoolean value);

    /*********************************************************
        Functions reserved for class driver use only.
        End-users should not call these functions.  
     *********************************************************/
ViStatus _VI_FUNC  KE2700_IviInit (ViRsrc resourceName, ViBoolean IDQuery, 
                                   ViBoolean reset, ViSession vi);
ViStatus _VI_FUNC  KE2700_IviClose (ViSession vi);   

/****************************************************************************
 *------------------------ Error And Completion Codes ----------------------*
 ****************************************************************************/

#define KE2700_WARN_OVER_RANGE                           IVIDMM_WARN_OVER_RANGE
#define KE2700_ERROR_MAX_TIME_EXCEEDED                   IVIDMM_ERROR_MAX_TIME_EXCEEDED
#define KE2700_ERROR_TRIGGER_NOT_SOFTWARE                IVIDMM_ERROR_TRIGGER_NOT_SOFTWARE
#define KE2700_ERROR_CHANNEL_LIST_NOT_ACCEPTED           (IVI_SPECIFIC_ERROR_BASE + 1)
#define KE2700_ERROR_SMALL_BUFFER                        (IVI_SPECIFIC_ERROR_BASE + 2)
#define KE2700_ERROR_INVALID_CHANNEL                     (IVI_SPECIFIC_ERROR_BASE + 3)
#define KE2700_ERROR_WRITE_INPUT_PORT                    (IVI_SPECIFIC_ERROR_BASE + 4)
#define KE2700_ERROR_ATTRIBUTE_NOSUPPORT                 (IVI_SPECIFIC_ERROR_BASE + 5)
#define KE2700_ERROR_DRY_CIRCUIT_NOSUPPORT               (IVI_SPECIFIC_ERROR_BASE + 6)
#define KE2700_ERROR_2701_ONLY                           (IVI_SPECIFIC_ERROR_BASE + 7)
#define KE2700_ERROR_2701_ASCII_ONLY                     (IVI_SPECIFIC_ERROR_BASE + 8)
#define KE2700_ERROR_TRIGGER_SLOPE  		             (IVI_SPECIFIC_ERROR_BASE + 9)
#define KE2700_ERROR_POWERLINE_FREQ 				     (IVI_SPECIFIC_ERROR_BASE + 10)
#define KE2700_ERROR_CONFIGURE_RTD 					     (IVI_SPECIFIC_ERROR_BASE + 11)
#define KE2700_ERROR_PASSWORD_REQUIRED				     (IVI_SPECIFIC_ERROR_BASE + 12)
#define KE2700_ERROR_INVALID_PASSWORD				     (IVI_SPECIFIC_ERROR_BASE + 13)
#define KE2700_ERROR_DIGITAL_PORTIO_NOSUPPORT 			 (IVI_SPECIFIC_ERROR_BASE + 14)
#define KE2700_ERROR_INVALID_SLOT                        (IVI_SPECIFIC_ERROR_BASE + 15)

/*- I/O buffer size -----------------------------------------------------*/
#define BUFFER_SIZE                                      512L

/****************************************************************************/
ViSession _VI_FUNC KE2700_ChannelList(ViSession Vi, ViConstString channelNames);

typedef struct _falseViSession
{
   const ViInt32 Key;   /*  'YKIV'   */
   ViSession     ValidVi;
   ViChar        ChnList[4*BUFFER_SIZE];
} FalseViSession;

#define  KE2700_VAL_RATE_FAST				   -1
#define  KE2700_VAL_RATE_MEDIUM				   -2
#define  KE2700_VAL_RATE_SLOW				   -3

// Constants for Measurement Events
#define  KE2700_EVENT_READING_OVERFLOW       	1
#define  KE2700_EVENT_LOW_LIMIT1       	        2
#define  KE2700_EVENT_HIGH_LIMIT1       	    4
#define  KE2700_EVENT_LOW_LIMIT2       	        8
#define  KE2700_EVENT_HIGH_LIMIT2       	    16

#define  KE2700_EVENT_READING_AVAIABLE       	(1L<<5)
#define  KE2700_EVENT_BUFFER_AVAIABLE       	(1L<<7)
#define  KE2700_EVENT_BUFFER_HALF_FULL  		(1L<<8)
#define  KE2700_EVENT_BUFFER_FULL       		(1L<<9)
#define  KE2700_EVENT_BUFFER_OVERFLOW       	(1L<<10)
#define  KE2700_EVENT_HARDWARE_LIMIT        	(1L<<11)
#define  KE2700_EVENT_BUFFER_QUARTER_FULL  		(1L<<12)
#define  KE2700_EVENT_BUFFER_3QUARTER_FULL  	(1L<<13)
#define  KE2700_EVENT_MASTER_LIMIT          	(1L<<14)

#define  IEEE_488_2_QUERY_ERROR_BIT				(1L<<2)
#define  IEEE_488_2_DEVICE_DEPENDENT_ERROR_BIT  (1L<<3)
#define  IEEE_488_2_EXECUTION_ERROR_BIT			(1L<<4)
#define  IEEE_488_2_COMMAND_ERROR_BIT			(1L<<5)
         	
// Constants for PORT Width
#define  KE2700_VAL_PORT_BYTE                   1
#define  KE2700_VAL_PORT_WORD                   2
#define  KE2700_VAL_PORT_DWORD                  3

/*- Attribute Values generated by CVI on 8/31/00 at 2:18 PM -------------*/
#define KE2700_VAL_TEMP_CELSIUS                 1
#define KE2700_VAL_TEMP_FAHRENHEIT              2
#define KE2700_VAL_TEMP_KELVIN                  3

/*- Attribute Values generated by CVI on 12/18/00 at 3:25 PM ------------*/
#define KE2700_VAL_PORT_ASCII                   1
#define KE2700_VAL_PORT_HEX                     2
#define KE2700_VAL_PORT_OCT                     3
#define KE2700_VAL_PORT_BIN                     4

// values for Switch Mode
#define KE2700_VAL_OPEN_MULTIPLE                            1
#define KE2700_VAL_OPEN_ALL                                 2
#define KE2700_VAL_CLOSE_MULTIPLE_IGNORE_OTHER_CHANNELS     3
#define KE2700_VAL_CLOSE_SINGLE_OPEN_OTHER_CHANNELS         4
#define KE2700_VAL_AUTO_CONFIGURE_ON                        5
#define KE2700_VAL_AUTO_CONFIGURE_OFF                       6

// values for Switch Get Mode
#define KE2700_VAL_MEASUREMENT_LIST             1
#define KE2700_VAL_CHANNEL_LIST                 2


#define KE2700_VAL_MAX_COUNT_INFINITE          -1
#define KE2700_VAL_NEXT_BUFFER_INDEX           -1

/*- Attribute Values generated by CVI on 3/14/2001 at 5:22 PM -----------*/
#define KE2700_VAL_KEY_SHIFT                                        1
#define KE2700_VAL_KEY_DCV                                          2
#define KE2700_VAL_KEY_ACV                                          3
#define KE2700_VAL_KEY_DCI                                          4
#define KE2700_VAL_KEY_ACI                                          5
#define KE2700_VAL_KEY_2W_OHMS                                      6
#define KE2700_VAL_KEY_4W_OHMS                                      7
#define KE2700_VAL_KEY_FREQ                                         8
#define KE2700_VAL_KEY_RANGE_UP                                     11
#define KE2700_VAL_KEY_AUTO                                         12
#define KE2700_VAL_KEY_ENTER                                        13
#define KE2700_VAL_KEY_RANGE_DOWN                                   14
#define KE2700_VAL_KEY_CURSOR_RIGHT                                 15
#define KE2700_VAL_KEY_TEMP                                         16
#define KE2700_VAL_KEY_EX_TRIG                                      18
#define KE2700_VAL_KEY_TRIG                                         19
#define KE2700_VAL_KEY_STORE                                        20
#define KE2700_VAL_KEY_RECALL                                       21
#define KE2700_VAL_KEY_FILTER                                       22
#define KE2700_VAL_KEY_REL                                          23
#define KE2700_VAL_KEY_CURSOR_LEFT                                  24
#define KE2700_VAL_KEY_OPEN                                         26
#define KE2700_VAL_KEY_CLOSE                                        27
#define KE2700_VAL_KEY_STEP                                         28
#define KE2700_VAL_KEY_SCAN                                         29
#define KE2700_VAL_KEY_DIGITS                                       30
#define KE2700_VAL_KEY_RATE                                         30
#define KE2700_VAL_KEY_EXIT                                         32

/*- Attribute Values generated by CVI on 3/14/2001 at 6:02 PM -----------*/
#define KE2700_VAL_SAV0                                             0
#define KE2700_VAL_SAV1                                             1
#define KE2700_VAL_SAV2                                             2
#define KE2700_VAL_SAV3                                             3

#define KE2700_VAL_BAUD_300                                         300
#define KE2700_VAL_BAUD_600                                         600
#define KE2700_VAL_BAUD_1200                                        1200
#define KE2700_VAL_BAUD_2400                                        2400
#define KE2700_VAL_BAUD_4800                                        4800
#define KE2700_VAL_BAUD_9600                                        9600
#define KE2700_VAL_BAUD_19200                                       19200
#define KE2700_VAL_BAUD_38400                                       38400
#define KE2700_VAL_BAUD_57600                                       57600
#define KE2700_VAL_BAUD_115200                                      115200
#define KE2700_VAL_NONE                                             1
#define KE2700_VAL_XONXOFF                                          2
#define KE2700_VAL_TERMINATOR_CR                                    1
#define KE2700_VAL_TERMINATOR_LF                                    2
#define KE2700_VAL_TERMINATOR_CRLF                                  3
#define KE2700_VAL_TERMINATOR_LFCR                                  4

#define KE2700_VAL_RTS_OFF                                          1
#define KE2700_VAL_RTS_IBFULL                                       2
#define KE2700_VAL_RTS_RDR                                          3

#define KE2700_VAL_POSITIVE                                         IVIDMM_VAL_POSITIVE
#define KE2700_VAL_NEGATIVE                                         IVIDMM_VAL_NEGATIVE


/**************************************************************************** 
 *---------------------------- End Include File ----------------------------* 
 ****************************************************************************/
#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif
#endif /* __KE2700_HEADER */

